
/**
 * Represents an undergraduate student majoring in Medieval Studies.
 */
public class MedievalStudiesStudent extends UndergradStudent
{

	private String[] medievalWordSet;
	
	public MedievalStudiesStudent(String name, int schoolYear) 
							throws InvalidFieldValueException {
		super(name, "Medieval Studies", schoolYear);
		//add additional words to the words the student uses.
		medievalWordSet = new String[] {"medieval", "knights",
				"romance", "library", "manuscript", "french", "gaelic",
				"norse", "celtic", "arthurian", "illuminated", "monk",
				"script", "vellum", "ancient", "text", "legend",
				"folklore", "culture", "ages", "germanic", "beowulf",
				"brythonic", "scriptorium", "quill"};
		String[] oldWords = this.getWordSet();
		String[] newWords = new String[medievalWordSet.length+oldWords.length];
		for (int i = 0; i < medievalWordSet.length; i++)
		{
			newWords[i] = medievalWordSet[i];
		}
		for (int i = 0; i < oldWords.length; i++)
		{
			newWords[i+medievalWordSet.length] = oldWords[i];
		}
		this.setWordSet(newWords);
	}

	@Override
	public String[] getMajorSpecificVocabulary() {
		return medievalWordSet;
	}

}
